# Nutanix DR Recovery Scripts

Automated DNS configuration scripts for Nutanix disaster recovery failover events.

## Overview

These scripts are executed by Nutanix Guest Tools during DR failover to automatically configure DNS settings based on the recovered VM's IP address location.

## Structure

```
recovery-scripts/
├── production/          # Production environment scripts
│   ├── vm_recovery.bat             # Main entry point (called by Nutanix Guest Tools)
│   └── Set-DnsConfiguration.ps1    # DNS configuration logic
└── test/                # Test environment scripts
    ├── vm_recovery.bat
    └── Set-DnsConfiguration.ps1
```

## Deployment to Windows VMs

### Prerequisites
- Windows Server with PowerShell 5.1 or higher
- Administrative privileges
- Nutanix Guest Tools installed
- PowerShell execution policy set to `RemoteSigned` or less restrictive

### Deployment Steps

1. **Copy Files to VM**
   ```powershell
   # Create directory
   New-Item -Path "C:\recovery-scripts\production" -ItemType Directory -Force

   # Copy files (use appropriate method: SCP, RDP copy/paste, etc.)
   # Ensure NO .DS_Store or other macOS files are copied
   ```

2. **Verify Files**
   ```powershell
   # Check files exist
   Get-ChildItem "C:\recovery-scripts\production"

   # Should show:
   # - vm_recovery.bat
   # - Set-DnsConfiguration.ps1
   ```

3. **Set PowerShell Execution Policy** (if needed)
   ```powershell
   # Check current policy
   Get-ExecutionPolicy

   # Set to RemoteSigned (allows local scripts, requires signature for remote)
   Set-ExecutionPolicy RemoteSigned -Scope LocalMachine -Force
   ```

4. **Configure Nutanix Guest Tools**
   - Set `vm_recovery.bat` as the post-recovery script
   - Ensure it runs with administrative privileges

5. **Test Execution**
   ```powershell
   # Run manually to test
   cd C:\recovery-scripts\production
   .\vm_recovery.bat

   # Check logs
   Get-ChildItem "C:\Program Files\Nutanix\scripts" | Sort-Object LastWriteTime -Descending
   ```

## Configuration

### DNS Site Configuration

Edit `Set-DnsConfiguration.ps1` to configure your sites:

```powershell
$sites = @{
    "SiteA" = @{
        "Subnets" = @("172.20.21.0/24")
        "DNSServers" = @("172.20.11.254")
    }
    "SiteB" = @{
        "Subnets" = @("172.20.121.0/24")
        "DNSServers" = @("172.20.14.254")
    }
}
```

### Adding Additional Recovery Scripts

To execute multiple scripts during recovery, edit `vm_recovery.bat` and add scripts in the "ADD ADDITIONAL SCRIPTS HERE" section following the provided template.

## Logs

All executions are logged with timestamps to prevent overwrites:

- **Batch Execution Log**: `C:\Program Files\Nutanix\scripts\vm_recovery_batch_YYYYMMDD-HHMM.log`
- **DNS Configuration Log**: `C:\Program Files\Nutanix\scripts\Set-DnsConfiguration_YYYYMMDD-HHMMSS.log`

## Version History

- **v2.0** (2025-01-23)
  - Renamed scripts following PowerShell best practices
  - Fixed critical CIDR subnet calculation bug
  - Added timestamped logging
  - Improved adapter selection (uses InterfaceMetric)
  - Multi-script execution framework
  - Order-independent DNS comparison
  - Removed console output for silent execution

- **v1.5** (Previous)
  - Initial DNS configuration automation

## Security

### Execution Policy

Scripts use `RemoteSigned` execution policy for security:
- **RemoteSigned**: Local scripts run without signature, downloaded scripts require signature
- **Better than Bypass**: Provides protection against malicious downloaded scripts
- **Better than Restricted**: Allows locally created/verified scripts to run

If you need to use a more restrictive policy, you can:
1. **Sign the scripts** with a code signing certificate
2. **Use AllSigned policy** with your organization's certificate

### Why Not Bypass?

While `Bypass` would work, it's not recommended because:
- ❌ No protection against malicious scripts
- ❌ Not compliance-friendly
- ❌ Security audit findings
- ✅ RemoteSigned provides adequate security for local scripts

## Notes

- **Production and Test folders are identical** - use either based on your environment
- Scripts run silently (no console output) as required by Nutanix Guest Tools
- Exit codes are properly propagated to indicate success/failure
- .DS_Store and other macOS files are excluded via .gitignore

## Support

Author: Mike Dent (mike@mikedent.io)
